/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourClimableVine;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.registry.NetherBlocks;

public class BlockAnchorTreeVine
extends BlockBaseNotFull
implements BehaviourClimableVine {
    protected static final VoxelShape SHAPE_SELECTION = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;

    public BlockAnchorTreeVine() {
        super(BehaviourBuilders.createStaticVine((MapColor)MapColor.f_283784_).m_222994_().m_60953_(BlockAnchorTreeVine::getLuminance));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.setDropItself(false);
    }

    protected static int getLuminance(BlockState blockState) {
        return blockState.m_61145_(SHAPE).map(s -> s == BlockProperties.TripleShape.BOTTOM ? 15 : 0).orElse(0);
    }

    public BlockBehaviour.OffsetType getOffsetType() {
        return BlockBehaviour.OffsetType.XZ;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{SHAPE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        Vec3 vec3d = state.m_60824_(view, pos);
        return SHAPE_SELECTION.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    @Environment(value=EnvType.CLIENT)
    public float m_7749_(BlockState state, BlockGetter view, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter view, BlockPos pos) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        Block up = world.m_8055_(pos.m_7494_()).m_60734_();
        if (up != this && up != NetherBlocks.ANCHOR_TREE_LEAVES && up != Blocks.f_50134_) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    @Environment(value=EnvType.CLIENT)
    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)NetherBlocks.ANCHOR_TREE_LEAVES);
    }
}

